#include <bits/stdc++.h>
using namespace std;

const short int N = 3005;
const short int INF = 32766;// + 1;

short int a[2 * N];

vector<short int> graph[N];
bool isL[2 * N][N];
bool isR[2 * N][N];

short int l[N];
short int r[N];

short int dist[N][N];
bool visited[N];

short int n, q;

void printGraph(){
    for(short int i = 0; i < n; ++i){
        cout << i << ": ";
        for(auto u : graph[i]){
            cout << u << ", ";
        }
        cout << "\n";
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    cin >> n >> q;

    for(short int i = 0; i < n; ++i){
        l[i] = -1;
        r[i] = -1;
    }

    for(short int i = 0; i < 2 * n; ++i){
        cin >> a[i];
        a[i]--;
    }

    if(n > N){
        for(short int i = 0; i < q; ++i)
            cout << "-1\n";
        return 0;
    }

    for(short int i = 0; i < 2 * n; ++i){
        if(l[a[i]] == -1)
            l[a[i]] = i;
        else
            r[a[i]] = i;
        /*
        if(i){
            for(short int j = 0; j < n; ++j){
                isL[i][j] = isL[i - 1][j];
            }
        }
        isL[i][a[i]] = true;
        */
    }

    /*
    for(short int i = 2 * n - 1; i >= 0; --i){
        if(i != 2 * n - 1){
            for(short int j = 0; j < n; ++j){
                isR[i][j] = isR[i + 1][j];
            }
        }
        isR[i][a[i]] = true;
    }
    */

    for(short int i = 0; i < n; ++i){
        for(short int j = i + 1; j < n; ++j){
            /*
            if(isL[l[i]][j] && isR[r[i]][j]){
                graph[i].push_back(j);
                graph[j].push_back(i);
            }
            */
            if((l[j] < l[i] && r[j] > r[i]) || (l[i] < l[j] && r[i] > r[j])){
                graph[i].push_back(j);
                graph[j].push_back(i);
            }
        }
    }

    //printGraph();

    for(short int i = 0; i < n; ++i){
        for(short int j = 0; j < n; ++j){
            dist[i][j] = INF;
        }
    }

    for(short int curSource = 0; curSource < n - 1; curSource++){
        for(short int i = 0; i < n; ++i){
            visited[i] = false;
        }

        dist[curSource][curSource] = 0;

        queue<pair<short int, short int>> qu;
        qu.push({curSource, 0});
        while(!qu.empty()){
            pair<short int, short int> v = qu.front();
            qu.pop();
            dist[curSource][v.first] = v.second;
            dist[v.first][curSource] = v.second;

            for(auto c : graph[v.first]){
                if(!visited[c]){
                    visited[c] = true;
                    qu.push({c, v.second + 1});
                }
            }
        }
    }


    while(q--){
        short int v, u;
        cin >> v >> u;
        v--;
        u--;
        if(dist[v][u] == INF){
            cout << "-1\n";
        }else{
            cout << dist[v][u] << "\n";
        }
    }
    return 0;
}